* Title: 	cdc_opioid_clean.do
* Version: 	23 May 2018
* Purpose: 	Clean opioid data from CDC

* Source: https://www.brookings.edu/bpea-articles/where-have-all-the-workers-gone-an-inquiry-into-the-decline-of-the-u-s-labor-force-participation-rate/
* Date accessed: 23 May 2018

*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using log/cdc_opioid_clean, replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load and clean spreadsheet from Krueger (2017)
*******************************************************************************

import excel using dta/raw/krugerdata_brookingsbpea092017.xlsx, clear sheet("OpioidLevels_County") first
rename County county
replace MME_PerCap_2015 = "" if MME_PerCap_2015 == "N/A"

*******************************************************************************
* (2) End of file
*******************************************************************************

destring _all, replace
sort county
compress

save dta/cdc_opioid_clean, replace

log close
exit, clear
